function [ S ] = Tri_to_Std( T , P )
%Given triangle and pts within find corresponding values on std element,
%ie convex hull <0,e1,e2> in plane by barycentric
%   We map our triangle onto 1\times Tri in R^{3}, then map onto <e1,e2,e3>
%   and finally project down onto the standard element beneath. (Note std
%   triangle is proj of <e1,e2,e3> onto x-y plane.  THIS CODE RUNS A MATRIX
%   INVERSION SO WATCH OUT FOR DEGENERACY!

%   T is (3 x 2) matrix giving
%   points and p is a (numpt x 2) row matrix. S outputs as (numpt x 2) row
%   matrix.

numpt = size(P,1);
%Assemble the barycentric coordinate transformation matrix
row1 = [[1 1 1]];
A = [row1; T'];   %[X;Y] code for stacking Y UNDERNEATH X in matrix

%Find point q on <e1,e2,e3>
x = [zeros(1,numpt)+1;P']; %This to map our points onto 1\times Tri

%q = A^(-1)*x; %Map from 1\times Tri into <e1,e2,e3>
q = A\x;
%Project down onto the x-y plane
q(3,:) = [];
S = q';


end

